<?php
include 'api_helper.php';

if (empty($_GET['slug'])) {
    die("Invalid blog");
}

$slug = $_GET['slug'];

$apiBase = 'https://blogsystem.online/api';
$currentDomain = $_SERVER['HTTP_HOST'];

$apiURL = $apiBase . '/blog-detail/' . urlencode($slug);

// 👇 domain param add karo
$response = callAPI($apiURL, 'GET', [
    'domain' => $currentDomain
]);

if (empty($response['success'])) {
    die('Blog not found');
}

$blog = $response['data'];
?>

<?php include 'header.php'; ?>

<main>
<section class="blog_area single-post-area section-padding">
<div class="container">
<div class="row">

    <!-- Full Blog -->
    <div class="col-lg-8 posts-list">

        <div class="single-post">
            <div class="feature-img">
                <img class="img-fluid" src="<?= $blog['image_url'] ?>" alt="">
            </div>

            <div class="blog_details">
                <h2><?= $blog['title']; ?></h2>

                <ul class="blog-info-link mt-3 mb-4">
                    <li><i class="fa fa-calendar"></i> <?= $blog['blog_date_f']; ?></li>
                </ul>

                <div class="content">
                    <?= $blog['info']; ?>
                </div>
            </div>
        </div>

    </div>

    <!-- Sidebar -->
    <div class="col-lg-4">
        <?php include 'sidebar.php'; ?>
    </div>

</div>
</div>
</section>
</main>

<?php include 'footer.php'; ?>
