<?php
include 'api_helper.php';

// Backend API URL
$apiBase = "https://blogsystem.online/api/blogs";

// Current frontend domain
$currentDomain = $_SERVER['HTTP_HOST'];

// Build parameters
$params = [
    'domain' => $currentDomain,
    'limit'  => 12,
    'page'   => 1
];

// Call API
$response = callAPI($apiBase, 'GET', $params);

// Solve if failed
$blogs = (!empty($response['success']) && !empty($response['data'])) ? $response['data'] : [];
?>
<?php include 'header.php';?>

    <main>
    <!-- Trending Area Start -->
    <div class="trending-area fix">
        <div class="container">
            <div class="trending-main">
                <!-- Trending Tittle -->
                <div class="row">
                    <div class="col-lg-12">
                       <div class="trending-tittle"> 
                        <strong>Trending now</strong>
                        <div class="trending-animated">
                            <ul id="js-news" class="js-hidden">
                                <?php
                                if ($result->num_rows > 0) {
                                    while($row = $result->fetch_assoc()) {
                                        echo '<li class="news-item">' . htmlspecialchars($row['title']) . '</li>';
                                    }
                                } else {
                                    echo '<li class="news-item">No recent blogs found.</li>';
                                }
                                ?>
                            </ul>
                        </div>
                    </div>

                    </div>
                </div>  
           </div>
        </div>
    </div>
    <!-- Trending Area End -->
   
      <!-- ================= Blog Area ================= -->
<section class="blog_area section-padding">
    <div class="container">
        <div class="row">

            <!-- Main Blog Column -->
            <div class="col-lg-8 mb-5 mb-lg-0">
                <div class="blog_left_sidebar">
                    <?php
                    if($result_main->num_rows > 0){
                        while($row = $result_main->fetch_assoc()){
                            $date = date('d', strtotime($row['blog_date']));
                            $month = date('M', strtotime($row['blog_date']));
                            
                            ?>
                            <?php
                                $image_path = 'assets/uploads/blog/' . $row['image'];
                                if (!empty($row['image']) && file_exists($image_path)) {
                                    $img_url = $image_path; // relative URL
                                } 
                                ?>

                            <article class="blog_item">
                                <div class="blog_item_img">
                                    <img src="<?= $img_url ?>" class="card-img rounded-0" alt="<?= htmlspecialchars($row['title']) ?>">
                                    <a href="<?= htmlspecialchars($row['blog_url']) ?>" class="blog_item_date">
                                        <h3><?= $date ?></h3>
                                        <p><?= $month ?></p>
                                    </a>
                                </div>
                                <div class="blog_details">
                                    <a class="d-inline-block" href="<?= htmlspecialchars($row['blog_url']) ?>">
                                        <h2><?= htmlspecialchars($row['title']) ?></h2>
                                    </a>
                                    <p><?= htmlspecialchars($row['short_desc']) ?></p>
                                    <ul class="blog-info-link">
                                        <li><a href="#"><i class="fa fa-user"></i> <?= htmlspecialchars($row['cat_name']) ?></a></li>
                                        <li><a href="#"><i class="fa fa-comments"></i> 0 Comments</a></li>
                                    </ul>
                                </div>
                            </article>
                            <?php
                        }
                    } else {
                        echo "<p>No blogs found.</p>";
                    }
                    ?>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <div class="blog_right_sidebar">

                    <!-- Categories -->
                    <aside class="single_sidebar_widget post_category_widget">
                        <h4 class="widget_title">Category</h4>
                        <ul class="list cat-list">
                            <?php
                            if($result_categories->num_rows > 0){
                                while($cat = $result_categories->fetch_assoc()){
                                    ?>
                                    <li>
                                        <a href="<?= htmlspecialchars($cat['cat_url']) ?>" class="d-flex">
                                            <p><?= htmlspecialchars($cat['cat_name']) ?></p>
                                            <p>(<?= $cat['post_count'] ?>)</p>
                                        </a>
                                    </li>
                                    <?php
                                }
                            } else {
                                echo "<li>No categories found</li>";
                            }
                            ?>
                        </ul>
                    </aside>

                    <!-- Recent Posts -->
                    <aside class="single_sidebar_widget popular_post_widget">
                        <h3 class="widget_title">Recent Post</h3>
                        <?php
                        if($result_recent->num_rows > 0){
                            while($post = $result_recent->fetch_assoc()){
                                $date = date('d M, Y', strtotime($post['blog_date']));
                                ?>
                                <div class="media post_item">
                                    <img src="<?= htmlspecialchars($post['image']) ?>" alt="post">
                                    <div class="media-body">
                                        <a href="<?= htmlspecialchars($post['blog_url']) ?>">
                                            <h3><?= htmlspecialchars($post['title']) ?></h3>
                                        </a>
                                        <p><?= $date ?></p>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                        ?>
                    </aside>

                    <!-- Tags -->
                    <aside class="single_sidebar_widget tag_cloud_widget">
                        <h4 class="widget_title">Tag Clouds</h4>
                        <ul class="list">
                            <?php
                            if(!empty($all_tags)){
                                foreach($all_tags as $tag){
                                    ?>
                                    <li><a href="#"><?= htmlspecialchars($tag) ?></a></li>
                                    <?php
                                }
                            }
                            ?>
                        </ul>
                    </aside>

                </div>
            </div>

        </div>
    </div>
</section>
    <!--================Blog Area =================-->

       <!--   Weekly2-News start -->
    <div class="weekly2-news-area  weekly2-pading gray-bg">
        <div class="container">
            <div class="weekly2-wrapper">
                <!-- section Tittle -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-tittle mb-30">
                            <h3>Weekly Top News</h3>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="weekly2-news-active dot-style d-flex dot-style">
                            <div class="weekly2-single">
                                <div class="weekly2-img">
                                    <img src="assets/img/news/weekly2News1.jpg" alt="">
                                </div>
                                <div class="weekly2-caption">
                                    <span class="color1">Corporate</span>
                                    <p>25 Jan 2020</p>
                                    <h4><a href="#">Welcome To The Best Model  Winner Contest</a></h4>
                                </div>
                            </div> 
                            <div class="weekly2-single">
                                <div class="weekly2-img">
                                    <img src="assets/img/news/weekly2News2.jpg" alt="">
                                </div>
                                <div class="weekly2-caption">
                                    <span class="color1">Event night</span>
                                    <p>25 Jan 2020</p>
                                    <h4><a href="#">Welcome To The Best Model  Winner Contest</a></h4>
                                </div>
                            </div> 
                            <div class="weekly2-single">
                                <div class="weekly2-img">
                                    <img src="assets/img/news/weekly2News3.jpg" alt="">
                                </div>
                                <div class="weekly2-caption">
                                    <span class="color1">Corporate</span>
                                    <p>25 Jan 2020</p>
                                    <h4><a href="#">Welcome To The Best Model  Winner Contest</a></h4>
                                </div>
                            </div>
                             <div class="weekly2-single">
                                <div class="weekly2-img">
                                    <img src="assets/img/news/weekly2News4.jpg" alt="">
                                </div>
                                <div class="weekly2-caption">
                                    <span class="color1">Event time</span>
                                    <p>25 Jan 2020</p>
                                    <h4><a href="#">Welcome To The Best Model  Winner Contest</a></h4>
                                </div>
                            </div> 
                             <div class="weekly2-single">
                                <div class="weekly2-img">
                                    <img src="assets/img/news/weekly2News4.jpg" alt="">
                                </div>
                                <div class="weekly2-caption">
                                    <span class="color1">Corporate</span>
                                    <p>25 Jan 2020</p>
                                    <h4><a href="#">Welcome To The Best Model  Winner Contest</a></h4>
                                </div>
                            </div> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>           
    <!-- End Weekly-News -->
   
    <!--Start pagination -->
    <div class="pagination-area pb-45 text-center">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="single-wrap d-flex justify-content-center">
                        <nav aria-label="Page navigation example">
                            <ul class="pagination justify-content-start">
                              <li class="page-item"><a class="page-link" href="#"><span class="flaticon-arrow roted"></span></a></li>
                                <li class="page-item active"><a class="page-link" href="#">01</a></li>
                                <li class="page-item"><a class="page-link" href="#">02</a></li>
                                <li class="page-item"><a class="page-link" href="#">03</a></li>
                              <li class="page-item"><a class="page-link" href="#"><span class="flaticon-arrow right-arrow"></span></a></li>
                            </ul>
                          </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End pagination  -->
    </main>
    
   <?php include 'footer.php'; ?>
