<?php
$slug = $_GET['slug'] ?? '';
if (empty($slug)) {
    header("Location: /");
    exit;
}

$domain = $_SERVER['HTTP_HOST'];
$apiURL = "https://blogsystem.online/api/blog-detail/$slug?domain=$domain";

$json = file_get_contents($apiURL);
$data = json_decode($json, true);

if (empty($data['success']) || empty($data['data'])) {
    die("Blog not found");
}

$blog = $data['data'];

?>
<title><?= $blog['title']; ?></title>
<meta name="description" content="<?= $blog['short_desc']; ?>">

<?php include 'header.php'?>

<main>
<section class="blog_area single-post-area section-padding">

<div class="container">
<div class="row">

    <!-- Full Blog -->
    <div class="col-lg-8 posts-list">

        <div class="single-post">
            <div class="feature-img">
                <img class="img-fluid" src="<?= $blog['image_url'] ?>" alt="<?= $blog['title']; ?>">
            </div>

            <div class="blog_details">
                <h2><?= $blog['title']; ?></h2>

                <ul class="blog-info-link mt-3 mb-4">
                    <li><i class="fa fa-calendar"></i> <?= $blog['blog_date_f']; ?></li>
                </ul>

                <div class="content">
                    <?= $blog['info']; ?>
                </div>
            </div>
        </div>

    </div>

<div class="col-lg-4">
   <div class="blog_right_sidebar">

<aside class="single_sidebar_widget post_category_widget">
    <h4 class="widget_title">Category</h4>
    <ul class="list cat-list">

        <?php if (!empty($blog['category'])): ?>
            <li>
                <a href="#">
                   <?= $blog['category']['name']; ?>
                </a>
            </li>
        <?php else: ?>
            <li>No category found.</li>
        <?php endif; ?>

    </ul>
</aside>


<aside class="single_sidebar_widget post_category_widget">
    <h4 class="widget_title">Tags</h4>
    <ul class="list cat-list">
        <?php if (!empty($blog)): ?>
  <?php foreach ($blog['tags'] as $t): ?>
  <li>         <span><?= $t['name']; ?></span></li>

    <?php endforeach; ?>
        <?php else: ?>
            <li>No tags</li>
        <?php endif; ?>
    </ul>
</aside>

     <!-- Recent Posts -->

</div>
</div>
</section>
</main>

<?php include 'footer.php'?>
