<?php
$BASE_URL = "https://winners11.store/";
?>
<?php
include 'api_helper.php';

$apiBase = "https://blogsystem.online/api/blogs";

$currentDomain = $_SERVER['HTTP_HOST'];

// ===============================
// MAIN BLOG LIST (12 blogs)
// ===============================
$params = [
    'domain' => $currentDomain,
    'limit'  => 12,
    'page'   => 1
];
$response = callAPI($apiBase, 'GET', $params);
$blogs = (!empty($response['success']) && !empty($response['data'])) ? $response['data'] : [];

// ===============================
// RECENT 3 BLOGS FOR SIDEBAR
// ===============================
$recentParams = [
    'domain' => $currentDomain,
    'limit'  => 3,
    'page'   => 1
];
$recentResponse = callAPI($apiBase, 'GET', $recentParams);
$recentBlogs = (!empty($recentResponse['success']) && !empty($recentResponse['data'])) ? $recentResponse['data'] : [];

// ===============================
// CATEGORIES
// ===============================
$categories = (!empty($response['categories'])) ? $response['categories'] : [];
?>


<div class="col-lg-4">
   <div class="blog_right_sidebar">

    <aside class="single_sidebar_widget post_category_widget">
    <h4 class="widget_title">Categories</h4>
    <ul class="list cat-list">
        <?php if (!empty($categories)): ?>
            <?php foreach ($categories as $cat): ?>
                <li>
                    <a href="<?= $BASE_URL . 'category/' . urlencode($cat['cat_url']) ?>" class="d-flex">
                        <p><?= htmlspecialchars($cat['cat_name']) ?></p>
                    </a>
                </li>
            <?php endforeach; ?>
        <?php else: ?>
            <li>No categories found.</li>
        <?php endif; ?>
    </ul>
</aside>

     <!-- Recent Posts -->
<!-- Recent Posts -->
<aside class="single_sidebar_widget popular_post_widget">
    <h3 class="widget_title">Recent Posts</h3>

    <?php if (!empty($recentBlogs)): ?>
        <?php foreach ($recentBlogs as $post): ?>
            <?php 
                $dateFormatted = date('F d, Y', strtotime($post['blog_date']));
            ?>
            <div class="media post_item mb-3">
                <img src="<?= htmlspecialchars($post['image_url']) ?>" 
                     alt="post" 
                     style="width: 70px; height: 70px; object-fit: cover; margin-right: 10px;">

                <div class="media-body">
                    <a href="<?= $BASE_URL . 'blog-detail/' . urlencode($post['blog_url']) ?>">
                        <h6 class="mt-0"><?= htmlspecialchars($post['title']) ?></h6>
                    </a>
                    <p class="text-muted" style="font-size: 12px;"><?= $dateFormatted ?></p>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p>No recent posts available.</p>
    <?php endif; ?>
</aside>


</div>
</div>
//blog.php
<!-- Recent Posts -->
<aside class="single_sidebar_widget popular_post_widget">
    <h3 class="widget_title">Recent Posts</h3>

    <?php if (!empty($recentBlogs)): ?>
        <?php foreach ($recentBlogs as $post): ?>
            <?php 
                $dateFormatted = date('F d, Y', strtotime($post['blog_date']));
            ?>
            <div class="media post_item mb-3">
                <img src="<?= htmlspecialchars($post['image_url']) ?>" 
                     alt="post" 
                     style="width: 70px; height: 70px; object-fit: cover; margin-right: 10px;">

                <div class="media-body">
                    <a href="<?= $BASE_URL . 'blog-detail/' . urlencode($post['blog_url']) ?>">
                        <h6 class="mt-0"><?= htmlspecialchars($post['title']) ?></h6>
                    </a>
                    <p class="text-muted" style="font-size: 12px;"><?= $dateFormatted ?></p>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p>No recent posts available.</p>
    <?php endif; ?>
</aside>

