<?php
include 'api_helper.php';

$apiBase = "https://blogsystem.online/api/blogs";
$currentDomain = $_SERVER['HTTP_HOST'];

// 🔹 Current page from URL
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

// 🔹 Category filter (optional)
$category_id = isset($_GET['category_id']) && $_GET['category_id'] !== ''
    ? (int)$_GET['category_id']
    : null;

// 🔹 Per page limit (main listing)
$limit = 5;

// 🔹 Reusable function for calling blogs API
function getBlogs($domain, $limit, $page = 1, $category_id = null) {
    global $apiBase;

    $params = [
        'domain' => $domain,
        'limit'  => $limit,
        'page'   => $page
    ];

    if (!empty($category_id)) {
        $params['category_id'] = $category_id;
    }

    return callAPI($apiBase, 'GET', $params);
}

// ===============================
// MAIN BLOG LIST (pagination)
// ===============================
$main = getBlogs($currentDomain, $limit, $page, $category_id);

$blogs = (!empty($main['success']) && !empty($main['data']))
    ? $main['data']
    : [];

// API se aane wale meta
$total        = isset($main['total']) ? (int)$main['total'] : 0;
$currentPage  = isset($main['page'])  ? (int)$main['page']  : $page;
$perPage      = isset($main['limit']) ? (int)$main['limit'] : $limit;
$totalPages   = $total > 0 ? ceil($total / $perPage) : 1;

// ===============================
// RECENT 3 BLOGS (SIDEBAR)
// (yaha pagination nahi chahiye)
// ===============================
$recent = getBlogs($currentDomain, 3, 1, null);

$recentBlogs = (!empty($recent['success']) && !empty($recent['data']))
    ? $recent['data']
    : [];

// ===============================
// COMMON VALUES (from main call)
// ===============================
$categories = $main['categories'] ?? [];
$tags       = $main['tags'] ?? [];
?>
<?php include 'header.php'; ?>

<main>
    <!-- Weekly-News start -->
<div class="weekly-news-area pt-50">
    <div class="container">
        <div class="weekly-wrapper">

            <!-- Section Title -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-tittle mb-30">
                        <h3>Weekly Top News</h3>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">

                    <div class="weekly-news-active dot-style d-flex">

                        <?php if (!empty($blogs)) { ?>
                            <?php foreach ($blogs as $b) { ?>
                                
                                <div class="weekly-single">
                                    
                                    <div class="weekly-img">
                                        <a href="<?= urlencode($b['blog_url']) ?>">
                                            <img src="<?= $b['image_url'] ?>" 
                                                 alt="<?= htmlspecialchars($b['title']); ?>"
                                                 style="width:100%; height:250px; object-fit:cover;">
                                        </a>
                                    </div>

                                    <div class="weekly-caption">
                                        <span class="color1"><?= $b['category']['cat_name'] ?? 'Blog' ?></span>

                                        <h4>
                                            <a href="<?= urlencode($b['blog_url']) ?>">
                                                <?= htmlspecialchars($b['title']); ?>
                                            </a>
                                        </h4>
                                    </div>

                                </div>

                            <?php } ?>
                        <?php } else { ?>
                            <p>No blogs found.</p>
                        <?php } ?>

                    </div>

                </div>
            </div>

        </div>
    </div>
</div>
<!-- End Weekly-News -->

<section class="blog_area section-padding">
<div class="container">
<div class="row">

    <!-- Main Blog Column -->
    <div class="col-lg-8 mb-5 mb-lg-0">
        <div class="blog_left_sidebar">

            <?php if (empty($blogs)): ?>
                <p>No blogs found.</p>

            <?php else: ?>
                <?php foreach ($blogs as $row): ?>

                    <?php
                        $date = date('d', strtotime($row['blog_date']));
                        $month = date('M', strtotime($row['blog_date']));
                    ?>

                    <article class="blog_item">
                        <div class="blog_item_img">
                            <img src="<?= $row['image_url']; ?>" 
                                 class="card-img rounded-0" 
                                 alt="<?= htmlspecialchars($row['title']) ?>">

                            <a href="$BASE_URL . "<?= urlencode($row['blog_url']) ?>" class="blog_item_date">
                                <h3><?= $date ?></h3>
                                <p><?= $month ?></p>
                            </a>
                        </div>

                        <div class="blog_details">
                          <a class="d-inline-block" 
   href="<?= $BASE_URL .  urlencode($row['blog_url']) ?>">



                                <h2><?= htmlspecialchars($row['title']) ?></h2>
                            </a>

                            <p><?= htmlspecialchars($row['short_desc']) ?></p>

                            <ul class="blog-info-link">
                                <li><a href="#"><i class="fa fa-user"></i> <?= htmlspecialchars($row['cat_name']) ?></a></li>
                                <li><a href="#"><i class="fa fa-comments"></i> 0 Comments</a></li>
                            </ul>
                        </div>
                    </article>

                <?php endforeach; ?>
            <?php endif; ?>

        </div>
    </div>
    
<div class="col-lg-4">
   <div class="blog_right_sidebar">

    <aside class="single_sidebar_widget post_category_widget">
    <h4 class="widget_title">Categories</h4>
    <ul class="list cat-list">
        <?php if (!empty($categories)): ?>
            <?php foreach ($categories as $cat): ?>
    <li>
        <a href="?category_id=<?= $cat['id']; ?>">
            <?= $cat['cat_name']; ?>
        </a>
    </li>

            <?php endforeach; ?>
        <?php else: ?>
            <li>No categories found.</li>
        <?php endif; ?>
    </ul>
</aside>

<aside class="single_sidebar_widget post_category_widget">
    <h4 class="widget_title">Tags</h4>
    <ul class="list cat-list">
        <?php if (!empty($tags)): ?>
            <?php foreach ($tags as $t): ?>
    <li>
        <a>
            <?= $t['name']; ?>
        </a>
    </li>

            <?php endforeach; ?>
        <?php else: ?>
            <li>No tags</li>
        <?php endif; ?>
    </ul>
</aside>

     <!-- Recent Posts -->
<!-- Recent Posts -->
<aside class="single_sidebar_widget popular_post_widget">
    <h3 class="widget_title">Recent Posts</h3>

    <?php if (!empty($recentBlogs)): ?>
        <?php foreach ($recentBlogs as $post): ?>
            <?php 
                $dateFormatted = date('F d, Y', strtotime($post['blog_date']));
            ?>
            <div class="media post_item mb-3">
                <img src="<?= htmlspecialchars($post['image_url']) ?>" 
                     alt="post" 
                     style="width: 70px; height: 70px; object-fit: cover; margin-right: 10px;">

                <div class="media-body">
                    <a href="<?= $BASE_URL . 'blog-detail/' . urlencode($post['blog_url']) ?>">
                        <h6 class="mt-0"><?= htmlspecialchars($post['title']) ?></h6>
                    </a>
                    <p class="text-muted" style="font-size: 12px;"><?= $dateFormatted ?></p>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p>No recent posts available.</p>
    <?php endif; ?>
</aside>


</div>
</div>
</div>
</div>
<div class="pagination-area pb-45 text-center">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="single-wrap d-flex justify-content-center">
                    <nav aria-label="Page navigation example">
                        <ul class="pagination justify-content-start">

                            <!-- Previous Button -->
                            <?php if ($page > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?= $page - 1 ?>">
                                        <span class="flaticon-arrow roted"></span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <!-- Page Numbers -->
                            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                                <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                                    <a class="page-link" href="?page=<?= $i ?>">
                                        <?= sprintf('%02d', $i) ?>
                                    </a>
                                </li>
                            <?php endfor; ?>

                            <!-- Next Button -->
                            <?php if ($page < $totalPages): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?= $page + 1 ?>">
                                        <span class="flaticon-arrow right-arrow"></span>
                                    </a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>

</section>

</main>

<?php include 'footer.php'; ?>
