<?php

function callAPI($url, $method = 'GET', $data = []) {

    $curl = curl_init();

    if ($method == 'GET' && !empty($data)) {
        $url .= '?' . http_build_query($data);
    }

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 15,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false
    ]);

    // For POST (if needed later)
    if ($method == 'POST') {
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
    }

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        return ['success' => false, 'message' => curl_error($curl)];
    }

    curl_close($curl);

    return json_decode($response, true);
}